<?php

function changeTimezones()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $arr = ParamGet($sock, "server");
   $arr = isset($arr->server->timezone) ? $arr->server->timezone : [];
   $timezones = $object["timezone"];
   $active = $object["active"];

   switch ($active) {
      case 1:
         $timezone = getServerTimeZone($arr, 0);
         changeTimeZone($sock, $timezone, 0, 0, 0);

         $timezone = getServerTimeZone($arr, 1);
         $time = isset($timezone) ? $timezone->start : 0;

         changeTimeZone($sock, $timezone, $time, 0, 1);

         $timezone = getServerTimeZone($arr, 2);
         $time = isset($timezone) ? $timezone->start : 0;

         changeTimeZone($sock, $timezone, $time, 0, 2);

         $timezone = getServerTimeZone($arr, 3);

         changeTimeZone($sock, $timezone, 0, 1, 3);

         break;
      case 2:
         $timezone = getServerTimeZone($arr, 0);
         changeTimeZone($sock, $timezone, $timezones[0]["start"], 1, 0);

         $timezone = getServerTimeZone($arr, 1);
         $time = isset($timezone) ? $timezone->start : 0;

         changeTimeZone($sock, $timezone, $time, 0, 1);

         $timezone = getServerTimeZone($arr, 2);
         $time = isset($timezone) ? $timezone->start : 0;

         changeTimeZone($sock, $timezone, $time, 0, 2);

         $timezone = getServerTimeZone($arr, 3);
         changeTimeZone($sock, $timezone, $timezones[1]["start"], 1, 3);
         break;
      case 3:
         $timezone = getServerTimeZone($arr, 0);
         changeTimeZone($sock, $timezone, $timezones[0]["start"], 1, 0);

         $timezone = getServerTimeZone($arr, 1);
         changeTimeZone($sock, $timezone, $timezones[1]["start"], 1, 1);

         $timezone = getServerTimeZone($arr, 2);
         $time = isset($timezone) ? $timezone->start : 0;
         changeTimeZone($sock, $timezone, $time, 0, 2);

         $timezone = getServerTimeZone($arr, 3);
         changeTimeZone($sock, $timezone, $timezones[2]["start"], 1, 3);
         break;
      case 4:
         $timezone = getServerTimeZone($arr, 0);
         changeTimeZone($sock, $timezone, $timezones[0]["start"], 1, 0);

         $timezone = getServerTimeZone($arr, 1);
         changeTimeZone($sock, $timezone, $timezones[1]["start"], 1, 1);

         $timezone = getServerTimeZone($arr, 2);
         changeTimeZone($sock, $timezone, $timezones[2]["start"], 1, 2);

         $timezone = getServerTimeZone($arr, 3);
         changeTimeZone($sock, $timezone, $timezones[3]["start"], 1, 3);
         break;
   }
   socket_close($sock);
}

function changeTimeZone($sock, $timezone, $start, $state, $index)
{
   if (isset($timezone)) {
      changeTimeZoneState($sock, $timezone, $state, $index);
      changeTimeZoneStart($sock, $timezone, $start, $index);
      return;
   }

   ParamSetInt($sock, "server.timezone.[" . $index . "].state", $state);
   ParamSetInt($sock, "server.timezone.[" . $index . "].start", $start);
}

function changeTimeZoneStart($sock, $timezone, $start, $index)
{
   if (isset($timezone->start)) {
      if ($timezone->start !== $start) {
         ParamSetInt($sock, "server.timezone.[" . $index . "].start", $start);
      }
      return;
   }

   ParamSetInt($sock, "server.timezone.[" . $index . "].start", $start);
}
function changeTimeZoneState($sock, $timezone, $state, $index)
{
   if (isset($timezone->state)) {
      if ($timezone->state !== $state) {
         ParamSetInt($sock, "server.timezone.[" . $index . "].state", $state);
      }
      return;
   }

   ParamSetInt($sock, "server.timezone.[" . $index . "].state", $state);
}

function getServerTimeZone($arr, $index)
{
   foreach ($arr as $obj) {
      if (isset($obj->index) && $obj->index === $index) {
         return $obj;
      }
   }

   return null;
}
